;This program is the exercise for Chapter 15 Serial Communications.  The LCD
;display is connected to PORTA,5.


	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80

;*******************************************************************************
;LCD defines
;********************************************************************************
#define	LCD_BKSPC	0x08			;move cursor left
#define	LCD_RT		0x09			;move cursor right
#define	LCD_LF		0x0A			;move cursor down 1 line
#define LCD_CLS		0x0C			;clear LCD (allow 5 ms delay to complete)
#define	LCD_CR		0x0D			;move position 0 of next line
#define	LCD_BL_ON	0x11			;backlight on
#define	LCD_BL_OFF	0x12			;backlight off
#define LCD_OFF		0x15			;LCD off
#define LCD_ON1		0x16			;LCD on, cursor off, blink off
#define LCD_ON2		0x17			;LCD on, cursor off, blink on
#define LCD_ON3		0x18			;LCD on, cursor on, blink off
#define	LCD_ON4		0x19			;LCD on, cursor of, blink on
#define LCD_LINE0	0x80			;move to line 1, column 0, add position to 0x80
#define LCD_LINE1	0x94			;move to line 2, column 0, add position to 0x94
#define LCD_LINE2	0xA8			;move to line 3, column 0, add position to 0xA8
#define LCD_LINE3	0xBC			;move to line 4, column 0, add position to 0xBC
;end LCD defines
;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	count			;used in delay routines
	tempa
	byte_to_send	;used in LCD Display
	bitcounter		
	endc
;******************************************************************************

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;goto interupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC		;clear port bus
	movlw	b'00000111'	;non inverted, comp with output
	movwf	CMCON		;
	movlw	b'00000000'	;interrupts disabled
	movwf	INTCON
	BANKSEL	Bank1		;use Bank1
	movlw	b'00000000'	;load w reg  
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00000000'	;load w reg with PORTA I/O 
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;load w reg with PORTC I/O
	movwf	TRISA		;program PORTC
	BANKSEL	Bank0		;back to bank0
;end pic initialization
	
;*****************************************************************************
;Initialize the LCD display
;*****************************************************************************
	bsf		PORTA,5			;set to high for resting state
	call	wait1sec		;to allow LCD to inialize
	movlw	LCD_CLS
	call	LCDOutput
	call	delay5mS		;to allow LCD to complete clear

;end LCD initialization
;****************************************************************************


;*****************************************************************************
;main program

	movlw	LCD_LINE0			;sends text to LCD display
	call	LCDOutput
	movlw	"H"
	call	LCDOutput
	movlw	"e"
	call	LCDOutput
	movlw	"l"
	call	LCDOutput
	movlw	"l"
	call	LCDOutput
	movlw	"o"
	call	LCDOutput

;	movlw	.1
;	addlw	.48
;	call	LCDOutput

self
	goto	self


;*****************************************************************************
;
;LCD Output
;put the desired value into the w register and call LCDOutput
;
;*****************************************************************************
LCDOutput
	movwf	byte_to_send
	movlw 	.8
	movwf 	bitcounter		;set up to send 8 bits
	bcf		PORTA,5			;send start bit
	call	bitdelay
nextbit
	bcf		PORTA,5
	rrf		byte_to_send,f	;sending lsb first
	btfsc	STATUS,C
	bsf		PORTA,5
	call	bitdelay
	decfsz	bitcounter,f
	goto	nextbit
	bsf		PORTA,5			;set to high for resting state
	call	delay5mS
	return
;end LCDOutput
;*******************************************************************************



;******************************************************************************
;Delay Routines
;******************************************************************************
;more delay options than needed, this is standard delay code I use in other programs
wait5sec
		call	wait1sec
		call	wait1sec
		call	wait1sec
		call	wait1sec		;1 seconds plus the one to follow
		

wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, F
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return
;delay200mS uses delay1mS to get a very accurate 200mS delay.
delay200mS
        movlw   .200
        movwf   tempa
dly200mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly200mS
        movlw   .64
        movwf   count
tweek200mS
        decfsz  count, F
        goto    tweek200mS
        return

bitdelay

		movlw	.30				;this number works if the user uses the calbrated
								;value for the internal clock. This routine, including
								;the goto and nop statements below allow the user to develop
								;an anticipated delay of 100uS for the bits at 9600 Baud.
								;This delay can be verified by using the stop watch function
								;of MPLab Simulator 
		movwf	count
		goto    $+1				;these goto statements allow you tweek the time of the
		goto	$+1				;delay.  Goto statements like this take 2 clock cycles
		nop						;while the nop statement takes 1 clock cycle to complete


bit
		decfsz	count, f
		goto	bit
		return
;end delay rountines



	end
